<?php
// Eski dosyanızdan dahil etmeniz gerekenler
include("include/baglan.php");
include("include/fonksiyonlar.php");
// Eğer giriş denemesi yapıldıysa ve hata varsa bu kısmı buraya ekleyebilirsiniz.
// Bu kısım genellikle fonksiyonlar.php içinde yer alır. Eğer hata mesajlarını bu sayfada göstermek istiyorsanız buraya ekleyebilirsiniz.
// Örnek:
// if (isset($_SESSION['login_hata'])) {
//     $hata_mesaji = $_SESSION['login_hata'];
//     unset($_SESSION['login_hata']);
// }
?>
<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - <?= $title ?></title>
    <meta name="description" content="Tailwind CSS Saas HTML Template Is A Multi Purpose Landing Page Template, Corporate, Authentication, Launching Web, Agency or Business Startup, Clean, Modern, Creative, Multipurpose and Tailwind CSS Tailwind v3 etc."/>
    <meta name="author" content="Zoyothemes"/>
    <link href="../imgupload/<?= $favicon ?>" rel="shortcut icon">
    <link href="assets2/css/style.css" rel="stylesheet" type="text/css">

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</head>
<body>
    <section class="relative h-screen w-full flex items-center justify-center bg-[conic-gradient(at_top_right,_var(--tw-gradient-stops))] from-[#ccf9df] to-[#d1d6ff]">
        <div class="relative max-w-lg md:mx-auto mx-6 w-full flex flex-col justify-center bg-white rounded-lg p-6">
            <div class="text-start mb-7">
                <a href="./" class="grow block mb-8">
                    <img class="h-8 mx-auto" src="../imgupload/<?= $logo ?>" alt="images">
                </a>
                <div class="text-center">
                    <h3 class="text-2xl font-semibold text-dark mb-3">Xoş gəldin, Admin</h3>
                    <p class="text-base font-medium text-light">Zəhmət olmasa panelə daxil olmaq üçün giriş məlumatları qeyd edin.</p>
                </div>
            </div>

            <form class="text-start w-full" action="include/fonksiyonlar.php" method="post">
                <?php if (isset($xeta_mesaji)) { ?>
                    <div class="text-center text-red-500 mb-4"><?= $xeta_mesaji ?></div>
                <?php } ?>

                <div class="mb-4">
                    <label for="email-addon" class="block text-base font-semibold text-dark mb-2">Gmailınız</label>
                    <input id="email-addon" class="block w-full rounded-md py-2.5 px-4 text-dark text-base font-medium border-gray-300 focus:gray-300 focus:border-primary focus:outline-0 focus:ring-0 placeholder:text-light placeholder:text-base" type="email" name="email" placeholder="Gmailınızı yazın">
                </div>

                <div class="mb-4">
                    <label for="password-addon" class="block text-base font-semibold text-dark mb-2">Şifrəniz</label>
                    <div class="flex">
                        <input type="password" id="password-addon" class="form-password text-dark text-base font-medium block w-full rounded-s-md py-2.5 px-4 border border-gray-300 focus:gray-300 focus:border-primary focus:outline-0 focus:ring-0 placeholder:text-light placeholder:text-base" name="sifre" placeholder="Şifrənizi yazın">
                        <button type="button" data-hs-toggle-password='{"target": "#password-addon"}' class="inline-flex items-center justify-center py-2.5 px-4 border rounded-e-md -ms-px border-gray-300">
                            <i class="hs-password-active:hidden h-5 w-5 text-dark" data-lucide="eye"></i>
                            <i data-lucide="eye-off" class="hidden hs-password-active:block h-5 w-5 text-dark"></i>
                        </button>
                    </div>
                </div>

                <div class="mb-6 flex justify-center">
                    <div class="g-recaptcha" data-sitekey="6Lcv7JArAAAAAJ6H7hDR_6PBXcrPhM9d4uL-7yAl"></div>
                </div>

                <input type="hidden" name="link" value="../daxil-ol.php">
                <div class="text-center mb-7">
                    <button type="submit" name="panel-giris" class="inline-flex items-center justify-center px-6 py-2.5 bg-primary font-bold text-base text-white rounded-md transition-all duration-500">DAXİL OL</button>
                </div>
            </form>

            <!-- <div class="flex items-center my-6">
                <div class="flex-auto mt-px border-t border-dashed border-gray-800"></div>
                <div class="mx-4 text-dark">Veya</div>
                <div class="flex-auto mt-px border-t border-dashed border-gray-800"></div>
            </div>

            <div class="flex md:justify-between justify-center items-center mb-8 md:gap-9 gap-2">
                <button type="submit" class="w-full inline-flex items-center justify-center px-6 gap-4 py-2.5 font-medium backdrop-blur-2xl border border-gray-300 bg-white text-dark rounded-md transition-all duration-500">
                    <img src="assets2/images/google.png" alt="" class="max-w-5 h-5 text-dark">Google
                </button>
                <button type="submit" class="w-full inline-flex items-center justify-center px-6 gap-4 py-2.5 font-medium backdrop-blur-2xl border border-gray-300 bg-white text-dark rounded-md transition-all duration-500 group">
                    <img src="assets2/images/facebook.png" alt="" class="max-w-5 h-5 text-dark">Facebook
                </button>
            </div> -->

            <p class="shrink text-light text-center">Copyright ©<a href="https://webmap.az" class="text-dark font-semibold ms-1"><b>Amid Nurmammadli</b></a></p>
        </div>
    </section>
    <script src="assets2/libs/preline/preline.js" ></script>
    <script src="assets2/libs/lucide/umd/lucide.min.js" ></script>
    <script src="assets2/js/app.js" ></script>
</body>
</html>